﻿################################################
# Update-Launcher.ps1
# Game Launcher update Script
# Version: 22.9.8.1
################################################
param ($LauncherLocation)

if (Test-Path -Path "$($PSScriptRoot)\Launcher-Install.exe")
{
	Get-Process -name Launcher -ErrorAction SilentlyContinue | Where-Object { $_.Path -eq $LauncherLocation } | Stop-Process -Force -ErrorAction SilentlyContinue -Confirm:$false
	# Wait some time for any file locks to release (just to be safe)
	Start-Sleep -seconds 2
    Start-Process -FilePath "$($PSScriptRoot)\Launcher-Install.exe" -ArgumentList "-silent" 
    $RunProcs = Get-Process -name Launcher -ErrorAction SilentlyContinue | Where-Object { $_.Path -eq $LauncherLocation }
    do {
        Start-Sleep -Seconds 2
    } until ($(Get-Process -name Launcher -ErrorAction SilentlyContinue | Where-Object { $_.Path -eq $LauncherLocation }) -ne $null)
}

